<?php
namespace EDAM\NoteStore;
/**
 * Autogenerated by Thrift Compiler (0.8.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
include_once $GLOBALS['THRIFT_ROOT'].'/Thrift.php';

include_once $GLOBALS['THRIFT_ROOT'].'/packages/NoteStore/NoteStore_types.php';

interface NoteStoreIf {
  public function getSyncState($authenticationToken);
  public function getSyncStateWithMetrics($authenticationToken, $clientMetrics);
  public function getSyncChunk($authenticationToken, $afterUSN, $maxEntries, $fullSyncOnly);
  public function getFilteredSyncChunk($authenticationToken, $afterUSN, $maxEntries, $filter);
  public function getLinkedNotebookSyncState($authenticationToken, $linkedNotebook);
  public function getLinkedNotebookSyncChunk($authenticationToken, $linkedNotebook, $afterUSN, $maxEntries, $fullSyncOnly);
  public function listNotebooks($authenticationToken);
  public function getNotebook($authenticationToken, $guid);
  public function getDefaultNotebook($authenticationToken);
  public function createNotebook($authenticationToken, $notebook);
  public function updateNotebook($authenticationToken, $notebook);
  public function expungeNotebook($authenticationToken, $guid);
  public function listTags($authenticationToken);
  public function listTagsByNotebook($authenticationToken, $notebookGuid);
  public function getTag($authenticationToken, $guid);
  public function createTag($authenticationToken, $tag);
  public function updateTag($authenticationToken, $tag);
  public function untagAll($authenticationToken, $guid);
  public function expungeTag($authenticationToken, $guid);
  public function listSearches($authenticationToken);
  public function getSearch($authenticationToken, $guid);
  public function createSearch($authenticationToken, $search);
  public function updateSearch($authenticationToken, $search);
  public function expungeSearch($authenticationToken, $guid);
  public function findNotes($authenticationToken, $filter, $offset, $maxNotes);
  public function findNoteOffset($authenticationToken, $filter, $guid);
  public function findNotesMetadata($authenticationToken, $filter, $offset, $maxNotes, $resultSpec);
  public function findNoteCounts($authenticationToken, $filter, $withTrash);
  public function getNote($authenticationToken, $guid, $withContent, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData);
  public function getNoteApplicationData($authenticationToken, $guid);
  public function getNoteApplicationDataEntry($authenticationToken, $guid, $key);
  public function setNoteApplicationDataEntry($authenticationToken, $guid, $key, $value);
  public function unsetNoteApplicationDataEntry($authenticationToken, $guid, $key);
  public function getNoteContent($authenticationToken, $guid);
  public function getNoteSearchText($authenticationToken, $guid, $noteOnly, $tokenizeForIndexing);
  public function getResourceSearchText($authenticationToken, $guid);
  public function getNoteTagNames($authenticationToken, $guid);
  public function createNote($authenticationToken, $note);
  public function updateNote($authenticationToken, $note);
  public function deleteNote($authenticationToken, $guid);
  public function expungeNote($authenticationToken, $guid);
  public function expungeNotes($authenticationToken, $noteGuids);
  public function expungeInactiveNotes($authenticationToken);
  public function copyNote($authenticationToken, $noteGuid, $toNotebookGuid);
  public function listNoteVersions($authenticationToken, $noteGuid);
  public function getNoteVersion($authenticationToken, $noteGuid, $updateSequenceNum, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData);
  public function getResource($authenticationToken, $guid, $withData, $withRecognition, $withAttributes, $withAlternateData);
  public function getResourceApplicationData($authenticationToken, $guid);
  public function getResourceApplicationDataEntry($authenticationToken, $guid, $key);
  public function setResourceApplicationDataEntry($authenticationToken, $guid, $key, $value);
  public function unsetResourceApplicationDataEntry($authenticationToken, $guid, $key);
  public function updateResource($authenticationToken, $resource);
  public function getResourceData($authenticationToken, $guid);
  public function getResourceByHash($authenticationToken, $noteGuid, $contentHash, $withData, $withRecognition, $withAlternateData);
  public function getResourceRecognition($authenticationToken, $guid);
  public function getResourceAlternateData($authenticationToken, $guid);
  public function getResourceAttributes($authenticationToken, $guid);
  public function getPublicNotebook($userId, $publicUri);
  public function createSharedNotebook($authenticationToken, $sharedNotebook);
  public function updateSharedNotebook($authenticationToken, $sharedNotebook);
  public function setSharedNotebookRecipientSettings($authenticationToken, $sharedNotebookId, $recipientSettings);
  public function sendMessageToSharedNotebookMembers($authenticationToken, $notebookGuid, $messageText, $recipients);
  public function listSharedNotebooks($authenticationToken);
  public function expungeSharedNotebooks($authenticationToken, $sharedNotebookIds);
  public function createLinkedNotebook($authenticationToken, $linkedNotebook);
  public function updateLinkedNotebook($authenticationToken, $linkedNotebook);
  public function listLinkedNotebooks($authenticationToken);
  public function expungeLinkedNotebook($authenticationToken, $guid);
  public function authenticateToSharedNotebook($shareKey, $authenticationToken);
  public function getSharedNotebookByAuth($authenticationToken);
  public function emailNote($authenticationToken, $parameters);
  public function shareNote($authenticationToken, $guid);
  public function stopSharingNote($authenticationToken, $guid);
  public function authenticateToSharedNote($guid, $noteKey, $authenticationToken);
  public function findRelated($authenticationToken, $query, $resultSpec);
}

class NoteStoreClient implements \EDAM\NoteStore\NoteStoreIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function getSyncState($authenticationToken)
  {
    $this->send_getSyncState($authenticationToken);
    return $this->recv_getSyncState();
  }

  public function send_getSyncState($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_getSyncState_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSyncState', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSyncState', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSyncState()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getSyncState_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getSyncState_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getSyncState failed: unknown result");
  }

  public function getSyncStateWithMetrics($authenticationToken, $clientMetrics)
  {
    $this->send_getSyncStateWithMetrics($authenticationToken, $clientMetrics);
    return $this->recv_getSyncStateWithMetrics();
  }

  public function send_getSyncStateWithMetrics($authenticationToken, $clientMetrics)
  {
    $args = new \EDAM\NoteStore\NoteStore_getSyncStateWithMetrics_args();
    $args->authenticationToken = $authenticationToken;
    $args->clientMetrics = $clientMetrics;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSyncStateWithMetrics', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSyncStateWithMetrics', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSyncStateWithMetrics()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getSyncStateWithMetrics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getSyncStateWithMetrics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getSyncStateWithMetrics failed: unknown result");
  }

  public function getSyncChunk($authenticationToken, $afterUSN, $maxEntries, $fullSyncOnly)
  {
    $this->send_getSyncChunk($authenticationToken, $afterUSN, $maxEntries, $fullSyncOnly);
    return $this->recv_getSyncChunk();
  }

  public function send_getSyncChunk($authenticationToken, $afterUSN, $maxEntries, $fullSyncOnly)
  {
    $args = new \EDAM\NoteStore\NoteStore_getSyncChunk_args();
    $args->authenticationToken = $authenticationToken;
    $args->afterUSN = $afterUSN;
    $args->maxEntries = $maxEntries;
    $args->fullSyncOnly = $fullSyncOnly;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSyncChunk', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSyncChunk', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSyncChunk()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getSyncChunk_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getSyncChunk_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getSyncChunk failed: unknown result");
  }

  public function getFilteredSyncChunk($authenticationToken, $afterUSN, $maxEntries, $filter)
  {
    $this->send_getFilteredSyncChunk($authenticationToken, $afterUSN, $maxEntries, $filter);
    return $this->recv_getFilteredSyncChunk();
  }

  public function send_getFilteredSyncChunk($authenticationToken, $afterUSN, $maxEntries, $filter)
  {
    $args = new \EDAM\NoteStore\NoteStore_getFilteredSyncChunk_args();
    $args->authenticationToken = $authenticationToken;
    $args->afterUSN = $afterUSN;
    $args->maxEntries = $maxEntries;
    $args->filter = $filter;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getFilteredSyncChunk', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getFilteredSyncChunk', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getFilteredSyncChunk()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getFilteredSyncChunk_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getFilteredSyncChunk_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getFilteredSyncChunk failed: unknown result");
  }

  public function getLinkedNotebookSyncState($authenticationToken, $linkedNotebook)
  {
    $this->send_getLinkedNotebookSyncState($authenticationToken, $linkedNotebook);
    return $this->recv_getLinkedNotebookSyncState();
  }

  public function send_getLinkedNotebookSyncState($authenticationToken, $linkedNotebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_getLinkedNotebookSyncState_args();
    $args->authenticationToken = $authenticationToken;
    $args->linkedNotebook = $linkedNotebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLinkedNotebookSyncState', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLinkedNotebookSyncState', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLinkedNotebookSyncState()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getLinkedNotebookSyncState_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getLinkedNotebookSyncState_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getLinkedNotebookSyncState failed: unknown result");
  }

  public function getLinkedNotebookSyncChunk($authenticationToken, $linkedNotebook, $afterUSN, $maxEntries, $fullSyncOnly)
  {
    $this->send_getLinkedNotebookSyncChunk($authenticationToken, $linkedNotebook, $afterUSN, $maxEntries, $fullSyncOnly);
    return $this->recv_getLinkedNotebookSyncChunk();
  }

  public function send_getLinkedNotebookSyncChunk($authenticationToken, $linkedNotebook, $afterUSN, $maxEntries, $fullSyncOnly)
  {
    $args = new \EDAM\NoteStore\NoteStore_getLinkedNotebookSyncChunk_args();
    $args->authenticationToken = $authenticationToken;
    $args->linkedNotebook = $linkedNotebook;
    $args->afterUSN = $afterUSN;
    $args->maxEntries = $maxEntries;
    $args->fullSyncOnly = $fullSyncOnly;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLinkedNotebookSyncChunk', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLinkedNotebookSyncChunk', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLinkedNotebookSyncChunk()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getLinkedNotebookSyncChunk_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getLinkedNotebookSyncChunk_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getLinkedNotebookSyncChunk failed: unknown result");
  }

  public function listNotebooks($authenticationToken)
  {
    $this->send_listNotebooks($authenticationToken);
    return $this->recv_listNotebooks();
  }

  public function send_listNotebooks($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_listNotebooks_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listNotebooks', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listNotebooks', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listNotebooks()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listNotebooks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listNotebooks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("listNotebooks failed: unknown result");
  }

  public function getNotebook($authenticationToken, $guid)
  {
    $this->send_getNotebook($authenticationToken, $guid);
    return $this->recv_getNotebook();
  }

  public function send_getNotebook($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNotebook failed: unknown result");
  }

  public function getDefaultNotebook($authenticationToken)
  {
    $this->send_getDefaultNotebook($authenticationToken);
    return $this->recv_getDefaultNotebook();
  }

  public function send_getDefaultNotebook($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_getDefaultNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getDefaultNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getDefaultNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getDefaultNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getDefaultNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getDefaultNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getDefaultNotebook failed: unknown result");
  }

  public function createNotebook($authenticationToken, $notebook)
  {
    $this->send_createNotebook($authenticationToken, $notebook);
    return $this->recv_createNotebook();
  }

  public function send_createNotebook($authenticationToken, $notebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_createNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->notebook = $notebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("createNotebook failed: unknown result");
  }

  public function updateNotebook($authenticationToken, $notebook)
  {
    $this->send_updateNotebook($authenticationToken, $notebook);
    return $this->recv_updateNotebook();
  }

  public function send_updateNotebook($authenticationToken, $notebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->notebook = $notebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("updateNotebook failed: unknown result");
  }

  public function expungeNotebook($authenticationToken, $guid)
  {
    $this->send_expungeNotebook($authenticationToken, $guid);
    return $this->recv_expungeNotebook();
  }

  public function send_expungeNotebook($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("expungeNotebook failed: unknown result");
  }

  public function listTags($authenticationToken)
  {
    $this->send_listTags($authenticationToken);
    return $this->recv_listTags();
  }

  public function send_listTags($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_listTags_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listTags', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listTags', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listTags()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listTags_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listTags_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("listTags failed: unknown result");
  }

  public function listTagsByNotebook($authenticationToken, $notebookGuid)
  {
    $this->send_listTagsByNotebook($authenticationToken, $notebookGuid);
    return $this->recv_listTagsByNotebook();
  }

  public function send_listTagsByNotebook($authenticationToken, $notebookGuid)
  {
    $args = new \EDAM\NoteStore\NoteStore_listTagsByNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->notebookGuid = $notebookGuid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listTagsByNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listTagsByNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listTagsByNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listTagsByNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listTagsByNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("listTagsByNotebook failed: unknown result");
  }

  public function getTag($authenticationToken, $guid)
  {
    $this->send_getTag($authenticationToken, $guid);
    return $this->recv_getTag();
  }

  public function send_getTag($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getTag_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getTag', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getTag', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getTag()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getTag_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getTag_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getTag failed: unknown result");
  }

  public function createTag($authenticationToken, $tag)
  {
    $this->send_createTag($authenticationToken, $tag);
    return $this->recv_createTag();
  }

  public function send_createTag($authenticationToken, $tag)
  {
    $args = new \EDAM\NoteStore\NoteStore_createTag_args();
    $args->authenticationToken = $authenticationToken;
    $args->tag = $tag;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createTag', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createTag', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createTag()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createTag_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createTag_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("createTag failed: unknown result");
  }

  public function updateTag($authenticationToken, $tag)
  {
    $this->send_updateTag($authenticationToken, $tag);
    return $this->recv_updateTag();
  }

  public function send_updateTag($authenticationToken, $tag)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateTag_args();
    $args->authenticationToken = $authenticationToken;
    $args->tag = $tag;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateTag', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateTag', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateTag()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateTag_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateTag_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("updateTag failed: unknown result");
  }

  public function untagAll($authenticationToken, $guid)
  {
    $this->send_untagAll($authenticationToken, $guid);
    $this->recv_untagAll();
  }

  public function send_untagAll($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_untagAll_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'untagAll', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('untagAll', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_untagAll()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_untagAll_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_untagAll_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    return;
  }

  public function expungeTag($authenticationToken, $guid)
  {
    $this->send_expungeTag($authenticationToken, $guid);
    return $this->recv_expungeTag();
  }

  public function send_expungeTag($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeTag_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeTag', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeTag', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeTag()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeTag_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeTag_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("expungeTag failed: unknown result");
  }

  public function listSearches($authenticationToken)
  {
    $this->send_listSearches($authenticationToken);
    return $this->recv_listSearches();
  }

  public function send_listSearches($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_listSearches_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listSearches', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listSearches', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listSearches()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listSearches_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listSearches_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("listSearches failed: unknown result");
  }

  public function getSearch($authenticationToken, $guid)
  {
    $this->send_getSearch($authenticationToken, $guid);
    return $this->recv_getSearch();
  }

  public function send_getSearch($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getSearch_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSearch', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSearch', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSearch()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getSearch_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getSearch_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getSearch failed: unknown result");
  }

  public function createSearch($authenticationToken, $search)
  {
    $this->send_createSearch($authenticationToken, $search);
    return $this->recv_createSearch();
  }

  public function send_createSearch($authenticationToken, $search)
  {
    $args = new \EDAM\NoteStore\NoteStore_createSearch_args();
    $args->authenticationToken = $authenticationToken;
    $args->search = $search;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createSearch', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createSearch', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createSearch()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createSearch_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createSearch_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("createSearch failed: unknown result");
  }

  public function updateSearch($authenticationToken, $search)
  {
    $this->send_updateSearch($authenticationToken, $search);
    return $this->recv_updateSearch();
  }

  public function send_updateSearch($authenticationToken, $search)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateSearch_args();
    $args->authenticationToken = $authenticationToken;
    $args->search = $search;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSearch', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSearch', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSearch()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateSearch_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateSearch_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("updateSearch failed: unknown result");
  }

  public function expungeSearch($authenticationToken, $guid)
  {
    $this->send_expungeSearch($authenticationToken, $guid);
    return $this->recv_expungeSearch();
  }

  public function send_expungeSearch($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeSearch_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeSearch', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeSearch', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeSearch()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeSearch_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeSearch_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("expungeSearch failed: unknown result");
  }

  public function findNotes($authenticationToken, $filter, $offset, $maxNotes)
  {
    $this->send_findNotes($authenticationToken, $filter, $offset, $maxNotes);
    return $this->recv_findNotes();
  }

  public function send_findNotes($authenticationToken, $filter, $offset, $maxNotes)
  {
    $args = new \EDAM\NoteStore\NoteStore_findNotes_args();
    $args->authenticationToken = $authenticationToken;
    $args->filter = $filter;
    $args->offset = $offset;
    $args->maxNotes = $maxNotes;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'findNotes', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('findNotes', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_findNotes()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_findNotes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_findNotes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("findNotes failed: unknown result");
  }

  public function findNoteOffset($authenticationToken, $filter, $guid)
  {
    $this->send_findNoteOffset($authenticationToken, $filter, $guid);
    return $this->recv_findNoteOffset();
  }

  public function send_findNoteOffset($authenticationToken, $filter, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_findNoteOffset_args();
    $args->authenticationToken = $authenticationToken;
    $args->filter = $filter;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'findNoteOffset', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('findNoteOffset', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_findNoteOffset()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_findNoteOffset_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_findNoteOffset_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("findNoteOffset failed: unknown result");
  }

  public function findNotesMetadata($authenticationToken, $filter, $offset, $maxNotes, $resultSpec)
  {
    $this->send_findNotesMetadata($authenticationToken, $filter, $offset, $maxNotes, $resultSpec);
    return $this->recv_findNotesMetadata();
  }

  public function send_findNotesMetadata($authenticationToken, $filter, $offset, $maxNotes, $resultSpec)
  {
    $args = new \EDAM\NoteStore\NoteStore_findNotesMetadata_args();
    $args->authenticationToken = $authenticationToken;
    $args->filter = $filter;
    $args->offset = $offset;
    $args->maxNotes = $maxNotes;
    $args->resultSpec = $resultSpec;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'findNotesMetadata', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('findNotesMetadata', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_findNotesMetadata()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_findNotesMetadata_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_findNotesMetadata_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("findNotesMetadata failed: unknown result");
  }

  public function findNoteCounts($authenticationToken, $filter, $withTrash)
  {
    $this->send_findNoteCounts($authenticationToken, $filter, $withTrash);
    return $this->recv_findNoteCounts();
  }

  public function send_findNoteCounts($authenticationToken, $filter, $withTrash)
  {
    $args = new \EDAM\NoteStore\NoteStore_findNoteCounts_args();
    $args->authenticationToken = $authenticationToken;
    $args->filter = $filter;
    $args->withTrash = $withTrash;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'findNoteCounts', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('findNoteCounts', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_findNoteCounts()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_findNoteCounts_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_findNoteCounts_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("findNoteCounts failed: unknown result");
  }

  public function getNote($authenticationToken, $guid, $withContent, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData)
  {
    $this->send_getNote($authenticationToken, $guid, $withContent, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData);
    return $this->recv_getNote();
  }

  public function send_getNote($authenticationToken, $guid, $withContent, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->withContent = $withContent;
    $args->withResourcesData = $withResourcesData;
    $args->withResourcesRecognition = $withResourcesRecognition;
    $args->withResourcesAlternateData = $withResourcesAlternateData;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNote failed: unknown result");
  }

  public function getNoteApplicationData($authenticationToken, $guid)
  {
    $this->send_getNoteApplicationData($authenticationToken, $guid);
    return $this->recv_getNoteApplicationData();
  }

  public function send_getNoteApplicationData($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteApplicationData_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteApplicationData', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteApplicationData', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteApplicationData()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteApplicationData_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteApplicationData_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteApplicationData failed: unknown result");
  }

  public function getNoteApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $this->send_getNoteApplicationDataEntry($authenticationToken, $guid, $key);
    return $this->recv_getNoteApplicationDataEntry();
  }

  public function send_getNoteApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteApplicationDataEntry failed: unknown result");
  }

  public function setNoteApplicationDataEntry($authenticationToken, $guid, $key, $value)
  {
    $this->send_setNoteApplicationDataEntry($authenticationToken, $guid, $key, $value);
    return $this->recv_setNoteApplicationDataEntry();
  }

  public function send_setNoteApplicationDataEntry($authenticationToken, $guid, $key, $value)
  {
    $args = new \EDAM\NoteStore\NoteStore_setNoteApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setNoteApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setNoteApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setNoteApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_setNoteApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_setNoteApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("setNoteApplicationDataEntry failed: unknown result");
  }

  public function unsetNoteApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $this->send_unsetNoteApplicationDataEntry($authenticationToken, $guid, $key);
    return $this->recv_unsetNoteApplicationDataEntry();
  }

  public function send_unsetNoteApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $args = new \EDAM\NoteStore\NoteStore_unsetNoteApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'unsetNoteApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('unsetNoteApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_unsetNoteApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_unsetNoteApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_unsetNoteApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("unsetNoteApplicationDataEntry failed: unknown result");
  }

  public function getNoteContent($authenticationToken, $guid)
  {
    $this->send_getNoteContent($authenticationToken, $guid);
    return $this->recv_getNoteContent();
  }

  public function send_getNoteContent($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteContent_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteContent', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteContent', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteContent()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteContent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteContent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteContent failed: unknown result");
  }

  public function getNoteSearchText($authenticationToken, $guid, $noteOnly, $tokenizeForIndexing)
  {
    $this->send_getNoteSearchText($authenticationToken, $guid, $noteOnly, $tokenizeForIndexing);
    return $this->recv_getNoteSearchText();
  }

  public function send_getNoteSearchText($authenticationToken, $guid, $noteOnly, $tokenizeForIndexing)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteSearchText_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->noteOnly = $noteOnly;
    $args->tokenizeForIndexing = $tokenizeForIndexing;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteSearchText', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteSearchText', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteSearchText()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteSearchText_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteSearchText_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteSearchText failed: unknown result");
  }

  public function getResourceSearchText($authenticationToken, $guid)
  {
    $this->send_getResourceSearchText($authenticationToken, $guid);
    return $this->recv_getResourceSearchText();
  }

  public function send_getResourceSearchText($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceSearchText_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceSearchText', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceSearchText', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceSearchText()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceSearchText_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceSearchText_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceSearchText failed: unknown result");
  }

  public function getNoteTagNames($authenticationToken, $guid)
  {
    $this->send_getNoteTagNames($authenticationToken, $guid);
    return $this->recv_getNoteTagNames();
  }

  public function send_getNoteTagNames($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteTagNames_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteTagNames', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteTagNames', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteTagNames()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteTagNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteTagNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteTagNames failed: unknown result");
  }

  public function createNote($authenticationToken, $note)
  {
    $this->send_createNote($authenticationToken, $note);
    return $this->recv_createNote();
  }

  public function send_createNote($authenticationToken, $note)
  {
    $args = new \EDAM\NoteStore\NoteStore_createNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->note = $note;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("createNote failed: unknown result");
  }

  public function updateNote($authenticationToken, $note)
  {
    $this->send_updateNote($authenticationToken, $note);
    return $this->recv_updateNote();
  }

  public function send_updateNote($authenticationToken, $note)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->note = $note;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("updateNote failed: unknown result");
  }

  public function deleteNote($authenticationToken, $guid)
  {
    $this->send_deleteNote($authenticationToken, $guid);
    return $this->recv_deleteNote();
  }

  public function send_deleteNote($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_deleteNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_deleteNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_deleteNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("deleteNote failed: unknown result");
  }

  public function expungeNote($authenticationToken, $guid)
  {
    $this->send_expungeNote($authenticationToken, $guid);
    return $this->recv_expungeNote();
  }

  public function send_expungeNote($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("expungeNote failed: unknown result");
  }

  public function expungeNotes($authenticationToken, $noteGuids)
  {
    $this->send_expungeNotes($authenticationToken, $noteGuids);
    return $this->recv_expungeNotes();
  }

  public function send_expungeNotes($authenticationToken, $noteGuids)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeNotes_args();
    $args->authenticationToken = $authenticationToken;
    $args->noteGuids = $noteGuids;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeNotes', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeNotes', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeNotes()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeNotes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeNotes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("expungeNotes failed: unknown result");
  }

  public function expungeInactiveNotes($authenticationToken)
  {
    $this->send_expungeInactiveNotes($authenticationToken);
    return $this->recv_expungeInactiveNotes();
  }

  public function send_expungeInactiveNotes($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeInactiveNotes_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeInactiveNotes', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeInactiveNotes', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeInactiveNotes()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeInactiveNotes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeInactiveNotes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("expungeInactiveNotes failed: unknown result");
  }

  public function copyNote($authenticationToken, $noteGuid, $toNotebookGuid)
  {
    $this->send_copyNote($authenticationToken, $noteGuid, $toNotebookGuid);
    return $this->recv_copyNote();
  }

  public function send_copyNote($authenticationToken, $noteGuid, $toNotebookGuid)
  {
    $args = new \EDAM\NoteStore\NoteStore_copyNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->noteGuid = $noteGuid;
    $args->toNotebookGuid = $toNotebookGuid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'copyNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('copyNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_copyNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_copyNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_copyNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("copyNote failed: unknown result");
  }

  public function listNoteVersions($authenticationToken, $noteGuid)
  {
    $this->send_listNoteVersions($authenticationToken, $noteGuid);
    return $this->recv_listNoteVersions();
  }

  public function send_listNoteVersions($authenticationToken, $noteGuid)
  {
    $args = new \EDAM\NoteStore\NoteStore_listNoteVersions_args();
    $args->authenticationToken = $authenticationToken;
    $args->noteGuid = $noteGuid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listNoteVersions', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listNoteVersions', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listNoteVersions()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listNoteVersions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listNoteVersions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("listNoteVersions failed: unknown result");
  }

  public function getNoteVersion($authenticationToken, $noteGuid, $updateSequenceNum, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData)
  {
    $this->send_getNoteVersion($authenticationToken, $noteGuid, $updateSequenceNum, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData);
    return $this->recv_getNoteVersion();
  }

  public function send_getNoteVersion($authenticationToken, $noteGuid, $updateSequenceNum, $withResourcesData, $withResourcesRecognition, $withResourcesAlternateData)
  {
    $args = new \EDAM\NoteStore\NoteStore_getNoteVersion_args();
    $args->authenticationToken = $authenticationToken;
    $args->noteGuid = $noteGuid;
    $args->updateSequenceNum = $updateSequenceNum;
    $args->withResourcesData = $withResourcesData;
    $args->withResourcesRecognition = $withResourcesRecognition;
    $args->withResourcesAlternateData = $withResourcesAlternateData;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNoteVersion', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNoteVersion', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNoteVersion()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getNoteVersion_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getNoteVersion_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getNoteVersion failed: unknown result");
  }

  public function getResource($authenticationToken, $guid, $withData, $withRecognition, $withAttributes, $withAlternateData)
  {
    $this->send_getResource($authenticationToken, $guid, $withData, $withRecognition, $withAttributes, $withAlternateData);
    return $this->recv_getResource();
  }

  public function send_getResource($authenticationToken, $guid, $withData, $withRecognition, $withAttributes, $withAlternateData)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResource_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->withData = $withData;
    $args->withRecognition = $withRecognition;
    $args->withAttributes = $withAttributes;
    $args->withAlternateData = $withAlternateData;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResource', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResource', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResource()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResource failed: unknown result");
  }

  public function getResourceApplicationData($authenticationToken, $guid)
  {
    $this->send_getResourceApplicationData($authenticationToken, $guid);
    return $this->recv_getResourceApplicationData();
  }

  public function send_getResourceApplicationData($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceApplicationData_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceApplicationData', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceApplicationData', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceApplicationData()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceApplicationData_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceApplicationData_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceApplicationData failed: unknown result");
  }

  public function getResourceApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $this->send_getResourceApplicationDataEntry($authenticationToken, $guid, $key);
    return $this->recv_getResourceApplicationDataEntry();
  }

  public function send_getResourceApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceApplicationDataEntry failed: unknown result");
  }

  public function setResourceApplicationDataEntry($authenticationToken, $guid, $key, $value)
  {
    $this->send_setResourceApplicationDataEntry($authenticationToken, $guid, $key, $value);
    return $this->recv_setResourceApplicationDataEntry();
  }

  public function send_setResourceApplicationDataEntry($authenticationToken, $guid, $key, $value)
  {
    $args = new \EDAM\NoteStore\NoteStore_setResourceApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setResourceApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setResourceApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setResourceApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_setResourceApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_setResourceApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("setResourceApplicationDataEntry failed: unknown result");
  }

  public function unsetResourceApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $this->send_unsetResourceApplicationDataEntry($authenticationToken, $guid, $key);
    return $this->recv_unsetResourceApplicationDataEntry();
  }

  public function send_unsetResourceApplicationDataEntry($authenticationToken, $guid, $key)
  {
    $args = new \EDAM\NoteStore\NoteStore_unsetResourceApplicationDataEntry_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'unsetResourceApplicationDataEntry', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('unsetResourceApplicationDataEntry', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_unsetResourceApplicationDataEntry()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_unsetResourceApplicationDataEntry_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_unsetResourceApplicationDataEntry_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("unsetResourceApplicationDataEntry failed: unknown result");
  }

  public function updateResource($authenticationToken, $resource)
  {
    $this->send_updateResource($authenticationToken, $resource);
    return $this->recv_updateResource();
  }

  public function send_updateResource($authenticationToken, $resource)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateResource_args();
    $args->authenticationToken = $authenticationToken;
    $args->resource = $resource;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateResource', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateResource', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateResource()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("updateResource failed: unknown result");
  }

  public function getResourceData($authenticationToken, $guid)
  {
    $this->send_getResourceData($authenticationToken, $guid);
    return $this->recv_getResourceData();
  }

  public function send_getResourceData($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceData_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceData', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceData', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceData()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceData_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceData_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceData failed: unknown result");
  }

  public function getResourceByHash($authenticationToken, $noteGuid, $contentHash, $withData, $withRecognition, $withAlternateData)
  {
    $this->send_getResourceByHash($authenticationToken, $noteGuid, $contentHash, $withData, $withRecognition, $withAlternateData);
    return $this->recv_getResourceByHash();
  }

  public function send_getResourceByHash($authenticationToken, $noteGuid, $contentHash, $withData, $withRecognition, $withAlternateData)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceByHash_args();
    $args->authenticationToken = $authenticationToken;
    $args->noteGuid = $noteGuid;
    $args->contentHash = $contentHash;
    $args->withData = $withData;
    $args->withRecognition = $withRecognition;
    $args->withAlternateData = $withAlternateData;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceByHash', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceByHash', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceByHash()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceByHash_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceByHash_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceByHash failed: unknown result");
  }

  public function getResourceRecognition($authenticationToken, $guid)
  {
    $this->send_getResourceRecognition($authenticationToken, $guid);
    return $this->recv_getResourceRecognition();
  }

  public function send_getResourceRecognition($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceRecognition_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceRecognition', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceRecognition', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceRecognition()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceRecognition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceRecognition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceRecognition failed: unknown result");
  }

  public function getResourceAlternateData($authenticationToken, $guid)
  {
    $this->send_getResourceAlternateData($authenticationToken, $guid);
    return $this->recv_getResourceAlternateData();
  }

  public function send_getResourceAlternateData($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceAlternateData_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceAlternateData', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceAlternateData', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceAlternateData()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceAlternateData_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceAlternateData_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceAlternateData failed: unknown result");
  }

  public function getResourceAttributes($authenticationToken, $guid)
  {
    $this->send_getResourceAttributes($authenticationToken, $guid);
    return $this->recv_getResourceAttributes();
  }

  public function send_getResourceAttributes($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_getResourceAttributes_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceAttributes', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceAttributes', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceAttributes()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getResourceAttributes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getResourceAttributes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getResourceAttributes failed: unknown result");
  }

  public function getPublicNotebook($userId, $publicUri)
  {
    $this->send_getPublicNotebook($userId, $publicUri);
    return $this->recv_getPublicNotebook();
  }

  public function send_getPublicNotebook($userId, $publicUri)
  {
    $args = new \EDAM\NoteStore\NoteStore_getPublicNotebook_args();
    $args->userId = $userId;
    $args->publicUri = $publicUri;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getPublicNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getPublicNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getPublicNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getPublicNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getPublicNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("getPublicNotebook failed: unknown result");
  }

  public function createSharedNotebook($authenticationToken, $sharedNotebook)
  {
    $this->send_createSharedNotebook($authenticationToken, $sharedNotebook);
    return $this->recv_createSharedNotebook();
  }

  public function send_createSharedNotebook($authenticationToken, $sharedNotebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_createSharedNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->sharedNotebook = $sharedNotebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createSharedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createSharedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createSharedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createSharedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createSharedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("createSharedNotebook failed: unknown result");
  }

  public function updateSharedNotebook($authenticationToken, $sharedNotebook)
  {
    $this->send_updateSharedNotebook($authenticationToken, $sharedNotebook);
    return $this->recv_updateSharedNotebook();
  }

  public function send_updateSharedNotebook($authenticationToken, $sharedNotebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateSharedNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->sharedNotebook = $sharedNotebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSharedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSharedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSharedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateSharedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateSharedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("updateSharedNotebook failed: unknown result");
  }

  public function setSharedNotebookRecipientSettings($authenticationToken, $sharedNotebookId, $recipientSettings)
  {
    $this->send_setSharedNotebookRecipientSettings($authenticationToken, $sharedNotebookId, $recipientSettings);
    return $this->recv_setSharedNotebookRecipientSettings();
  }

  public function send_setSharedNotebookRecipientSettings($authenticationToken, $sharedNotebookId, $recipientSettings)
  {
    $args = new \EDAM\NoteStore\NoteStore_setSharedNotebookRecipientSettings_args();
    $args->authenticationToken = $authenticationToken;
    $args->sharedNotebookId = $sharedNotebookId;
    $args->recipientSettings = $recipientSettings;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setSharedNotebookRecipientSettings', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setSharedNotebookRecipientSettings', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setSharedNotebookRecipientSettings()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_setSharedNotebookRecipientSettings_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_setSharedNotebookRecipientSettings_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("setSharedNotebookRecipientSettings failed: unknown result");
  }

  public function sendMessageToSharedNotebookMembers($authenticationToken, $notebookGuid, $messageText, $recipients)
  {
    $this->send_sendMessageToSharedNotebookMembers($authenticationToken, $notebookGuid, $messageText, $recipients);
    return $this->recv_sendMessageToSharedNotebookMembers();
  }

  public function send_sendMessageToSharedNotebookMembers($authenticationToken, $notebookGuid, $messageText, $recipients)
  {
    $args = new \EDAM\NoteStore\NoteStore_sendMessageToSharedNotebookMembers_args();
    $args->authenticationToken = $authenticationToken;
    $args->notebookGuid = $notebookGuid;
    $args->messageText = $messageText;
    $args->recipients = $recipients;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'sendMessageToSharedNotebookMembers', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('sendMessageToSharedNotebookMembers', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_sendMessageToSharedNotebookMembers()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_sendMessageToSharedNotebookMembers_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_sendMessageToSharedNotebookMembers_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("sendMessageToSharedNotebookMembers failed: unknown result");
  }

  public function listSharedNotebooks($authenticationToken)
  {
    $this->send_listSharedNotebooks($authenticationToken);
    return $this->recv_listSharedNotebooks();
  }

  public function send_listSharedNotebooks($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_listSharedNotebooks_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listSharedNotebooks', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listSharedNotebooks', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listSharedNotebooks()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listSharedNotebooks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listSharedNotebooks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("listSharedNotebooks failed: unknown result");
  }

  public function expungeSharedNotebooks($authenticationToken, $sharedNotebookIds)
  {
    $this->send_expungeSharedNotebooks($authenticationToken, $sharedNotebookIds);
    return $this->recv_expungeSharedNotebooks();
  }

  public function send_expungeSharedNotebooks($authenticationToken, $sharedNotebookIds)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeSharedNotebooks_args();
    $args->authenticationToken = $authenticationToken;
    $args->sharedNotebookIds = $sharedNotebookIds;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeSharedNotebooks', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeSharedNotebooks', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeSharedNotebooks()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeSharedNotebooks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeSharedNotebooks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("expungeSharedNotebooks failed: unknown result");
  }

  public function createLinkedNotebook($authenticationToken, $linkedNotebook)
  {
    $this->send_createLinkedNotebook($authenticationToken, $linkedNotebook);
    return $this->recv_createLinkedNotebook();
  }

  public function send_createLinkedNotebook($authenticationToken, $linkedNotebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_createLinkedNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->linkedNotebook = $linkedNotebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createLinkedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createLinkedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createLinkedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_createLinkedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_createLinkedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("createLinkedNotebook failed: unknown result");
  }

  public function updateLinkedNotebook($authenticationToken, $linkedNotebook)
  {
    $this->send_updateLinkedNotebook($authenticationToken, $linkedNotebook);
    return $this->recv_updateLinkedNotebook();
  }

  public function send_updateLinkedNotebook($authenticationToken, $linkedNotebook)
  {
    $args = new \EDAM\NoteStore\NoteStore_updateLinkedNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->linkedNotebook = $linkedNotebook;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateLinkedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateLinkedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateLinkedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_updateLinkedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_updateLinkedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("updateLinkedNotebook failed: unknown result");
  }

  public function listLinkedNotebooks($authenticationToken)
  {
    $this->send_listLinkedNotebooks($authenticationToken);
    return $this->recv_listLinkedNotebooks();
  }

  public function send_listLinkedNotebooks($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_listLinkedNotebooks_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listLinkedNotebooks', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listLinkedNotebooks', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listLinkedNotebooks()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_listLinkedNotebooks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_listLinkedNotebooks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("listLinkedNotebooks failed: unknown result");
  }

  public function expungeLinkedNotebook($authenticationToken, $guid)
  {
    $this->send_expungeLinkedNotebook($authenticationToken, $guid);
    return $this->recv_expungeLinkedNotebook();
  }

  public function send_expungeLinkedNotebook($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_expungeLinkedNotebook_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'expungeLinkedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('expungeLinkedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_expungeLinkedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_expungeLinkedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_expungeLinkedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("expungeLinkedNotebook failed: unknown result");
  }

  public function authenticateToSharedNotebook($shareKey, $authenticationToken)
  {
    $this->send_authenticateToSharedNotebook($shareKey, $authenticationToken);
    return $this->recv_authenticateToSharedNotebook();
  }

  public function send_authenticateToSharedNotebook($shareKey, $authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_authenticateToSharedNotebook_args();
    $args->shareKey = $shareKey;
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'authenticateToSharedNotebook', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('authenticateToSharedNotebook', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_authenticateToSharedNotebook()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_authenticateToSharedNotebook_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_authenticateToSharedNotebook_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("authenticateToSharedNotebook failed: unknown result");
  }

  public function getSharedNotebookByAuth($authenticationToken)
  {
    $this->send_getSharedNotebookByAuth($authenticationToken);
    return $this->recv_getSharedNotebookByAuth();
  }

  public function send_getSharedNotebookByAuth($authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_getSharedNotebookByAuth_args();
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSharedNotebookByAuth', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSharedNotebookByAuth', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSharedNotebookByAuth()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_getSharedNotebookByAuth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_getSharedNotebookByAuth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("getSharedNotebookByAuth failed: unknown result");
  }

  public function emailNote($authenticationToken, $parameters)
  {
    $this->send_emailNote($authenticationToken, $parameters);
    $this->recv_emailNote();
  }

  public function send_emailNote($authenticationToken, $parameters)
  {
    $args = new \EDAM\NoteStore\NoteStore_emailNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->parameters = $parameters;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'emailNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('emailNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_emailNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_emailNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_emailNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    return;
  }

  public function shareNote($authenticationToken, $guid)
  {
    $this->send_shareNote($authenticationToken, $guid);
    return $this->recv_shareNote();
  }

  public function send_shareNote($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_shareNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shareNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shareNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shareNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_shareNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_shareNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("shareNote failed: unknown result");
  }

  public function stopSharingNote($authenticationToken, $guid)
  {
    $this->send_stopSharingNote($authenticationToken, $guid);
    $this->recv_stopSharingNote();
  }

  public function send_stopSharingNote($authenticationToken, $guid)
  {
    $args = new \EDAM\NoteStore\NoteStore_stopSharingNote_args();
    $args->authenticationToken = $authenticationToken;
    $args->guid = $guid;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'stopSharingNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('stopSharingNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_stopSharingNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_stopSharingNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_stopSharingNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    return;
  }

  public function authenticateToSharedNote($guid, $noteKey, $authenticationToken)
  {
    $this->send_authenticateToSharedNote($guid, $noteKey, $authenticationToken);
    return $this->recv_authenticateToSharedNote();
  }

  public function send_authenticateToSharedNote($guid, $noteKey, $authenticationToken)
  {
    $args = new \EDAM\NoteStore\NoteStore_authenticateToSharedNote_args();
    $args->guid = $guid;
    $args->noteKey = $noteKey;
    $args->authenticationToken = $authenticationToken;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'authenticateToSharedNote', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('authenticateToSharedNote', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_authenticateToSharedNote()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_authenticateToSharedNote_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_authenticateToSharedNote_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    throw new \Exception("authenticateToSharedNote failed: unknown result");
  }

  public function findRelated($authenticationToken, $query, $resultSpec)
  {
    $this->send_findRelated($authenticationToken, $query, $resultSpec);
    return $this->recv_findRelated();
  }

  public function send_findRelated($authenticationToken, $query, $resultSpec)
  {
    $args = new \EDAM\NoteStore\NoteStore_findRelated_args();
    $args->authenticationToken = $authenticationToken;
    $args->query = $query;
    $args->resultSpec = $resultSpec;
    $bin_accel = ($this->output_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'findRelated', \TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('findRelated', \TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_findRelated()
  {
    $bin_accel = ($this->input_ instanceof \TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\EDAM\NoteStore\NoteStore_findRelated_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == \TMessageType::EXCEPTION) {
        $x = new \TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \EDAM\NoteStore\NoteStore_findRelated_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->userException !== null) {
      throw $result->userException;
    }
    if ($result->systemException !== null) {
      throw $result->systemException;
    }
    if ($result->notFoundException !== null) {
      throw $result->notFoundException;
    }
    throw new \Exception("findRelated failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class NoteStore_getSyncState_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncState_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncState_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSyncState_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncState',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncState_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncState();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncState_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSyncStateWithMetrics_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $clientMetrics = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'clientMetrics',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\ClientUsageMetrics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['clientMetrics'])) {
        $this->clientMetrics = $vals['clientMetrics'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncStateWithMetrics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->clientMetrics = new \EDAM\NoteStore\ClientUsageMetrics();
            $xfer += $this->clientMetrics->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncStateWithMetrics_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->clientMetrics !== null) {
      if (!is_object($this->clientMetrics)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('clientMetrics', \TType::STRUCT, 2);
      $xfer += $this->clientMetrics->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSyncStateWithMetrics_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncState',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncStateWithMetrics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncState();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncStateWithMetrics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSyncChunk_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $afterUSN = null;
  public $maxEntries = null;
  public $fullSyncOnly = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'afterUSN',
          'type' => \TType::I32,
          ),
        3 => array(
          'var' => 'maxEntries',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'fullSyncOnly',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['afterUSN'])) {
        $this->afterUSN = $vals['afterUSN'];
      }
      if (isset($vals['maxEntries'])) {
        $this->maxEntries = $vals['maxEntries'];
      }
      if (isset($vals['fullSyncOnly'])) {
        $this->fullSyncOnly = $vals['fullSyncOnly'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncChunk_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->afterUSN);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->maxEntries);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->fullSyncOnly);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncChunk_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->afterUSN !== null) {
      $xfer += $output->writeFieldBegin('afterUSN', \TType::I32, 2);
      $xfer += $output->writeI32($this->afterUSN);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxEntries !== null) {
      $xfer += $output->writeFieldBegin('maxEntries', \TType::I32, 3);
      $xfer += $output->writeI32($this->maxEntries);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fullSyncOnly !== null) {
      $xfer += $output->writeFieldBegin('fullSyncOnly', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->fullSyncOnly);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSyncChunk_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncChunk',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSyncChunk_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncChunk();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSyncChunk_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getFilteredSyncChunk_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $afterUSN = null;
  public $maxEntries = null;
  public $filter = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'afterUSN',
          'type' => \TType::I32,
          ),
        3 => array(
          'var' => 'maxEntries',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'filter',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncChunkFilter',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['afterUSN'])) {
        $this->afterUSN = $vals['afterUSN'];
      }
      if (isset($vals['maxEntries'])) {
        $this->maxEntries = $vals['maxEntries'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getFilteredSyncChunk_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->afterUSN);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->maxEntries);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::STRUCT) {
            $this->filter = new \EDAM\NoteStore\SyncChunkFilter();
            $xfer += $this->filter->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getFilteredSyncChunk_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->afterUSN !== null) {
      $xfer += $output->writeFieldBegin('afterUSN', \TType::I32, 2);
      $xfer += $output->writeI32($this->afterUSN);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxEntries !== null) {
      $xfer += $output->writeFieldBegin('maxEntries', \TType::I32, 3);
      $xfer += $output->writeI32($this->maxEntries);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      if (!is_object($this->filter)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filter', \TType::STRUCT, 4);
      $xfer += $this->filter->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getFilteredSyncChunk_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncChunk',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getFilteredSyncChunk_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncChunk();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getFilteredSyncChunk_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getLinkedNotebookSyncState_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $linkedNotebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'linkedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LinkedNotebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['linkedNotebook'])) {
        $this->linkedNotebook = $vals['linkedNotebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getLinkedNotebookSyncState_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->linkedNotebook = new \EDAM\Types\LinkedNotebook();
            $xfer += $this->linkedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getLinkedNotebookSyncState_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->linkedNotebook !== null) {
      if (!is_object($this->linkedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('linkedNotebook', \TType::STRUCT, 2);
      $xfer += $this->linkedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getLinkedNotebookSyncState_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncState',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getLinkedNotebookSyncState_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncState();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getLinkedNotebookSyncState_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getLinkedNotebookSyncChunk_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $linkedNotebook = null;
  public $afterUSN = null;
  public $maxEntries = null;
  public $fullSyncOnly = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'linkedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LinkedNotebook',
          ),
        3 => array(
          'var' => 'afterUSN',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'maxEntries',
          'type' => \TType::I32,
          ),
        5 => array(
          'var' => 'fullSyncOnly',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['linkedNotebook'])) {
        $this->linkedNotebook = $vals['linkedNotebook'];
      }
      if (isset($vals['afterUSN'])) {
        $this->afterUSN = $vals['afterUSN'];
      }
      if (isset($vals['maxEntries'])) {
        $this->maxEntries = $vals['maxEntries'];
      }
      if (isset($vals['fullSyncOnly'])) {
        $this->fullSyncOnly = $vals['fullSyncOnly'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getLinkedNotebookSyncChunk_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->linkedNotebook = new \EDAM\Types\LinkedNotebook();
            $xfer += $this->linkedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->afterUSN);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->maxEntries);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->fullSyncOnly);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getLinkedNotebookSyncChunk_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->linkedNotebook !== null) {
      if (!is_object($this->linkedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('linkedNotebook', \TType::STRUCT, 2);
      $xfer += $this->linkedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->afterUSN !== null) {
      $xfer += $output->writeFieldBegin('afterUSN', \TType::I32, 3);
      $xfer += $output->writeI32($this->afterUSN);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxEntries !== null) {
      $xfer += $output->writeFieldBegin('maxEntries', \TType::I32, 4);
      $xfer += $output->writeI32($this->maxEntries);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fullSyncOnly !== null) {
      $xfer += $output->writeFieldBegin('fullSyncOnly', \TType::BOOL, 5);
      $xfer += $output->writeBool($this->fullSyncOnly);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getLinkedNotebookSyncChunk_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\SyncChunk',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getLinkedNotebookSyncChunk_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\SyncChunk();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getLinkedNotebookSyncChunk_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listNotebooks_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listNotebooks_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listNotebooks_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listNotebooks_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\Notebook',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listNotebooks_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size193 = 0;
            $_etype196 = 0;
            $xfer += $input->readListBegin($_etype196, $_size193);
            for ($_i197 = 0; $_i197 < $_size193; ++$_i197)
            {
              $elem198 = null;
              $elem198 = new \EDAM\Types\Notebook();
              $xfer += $elem198->read($input);
              $this->success []= $elem198;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listNotebooks_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter199)
          {
            $xfer += $iter199->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Notebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getDefaultNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getDefaultNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getDefaultNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getDefaultNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getDefaultNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Notebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getDefaultNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $notebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'notebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['notebook'])) {
        $this->notebook = $vals['notebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notebook = new \EDAM\Types\Notebook();
            $xfer += $this->notebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notebook !== null) {
      if (!is_object($this->notebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('notebook', \TType::STRUCT, 2);
      $xfer += $this->notebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Notebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $notebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'notebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['notebook'])) {
        $this->notebook = $vals['notebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notebook = new \EDAM\Types\Notebook();
            $xfer += $this->notebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notebook !== null) {
      if (!is_object($this->notebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('notebook', \TType::STRUCT, 2);
      $xfer += $this->notebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateNotebook_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNotebook_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listTags_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listTags_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listTags_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listTags_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\Tag',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listTags_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size200 = 0;
            $_etype203 = 0;
            $xfer += $input->readListBegin($_etype203, $_size200);
            for ($_i204 = 0; $_i204 < $_size200; ++$_i204)
            {
              $elem205 = null;
              $elem205 = new \EDAM\Types\Tag();
              $xfer += $elem205->read($input);
              $this->success []= $elem205;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listTags_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter206)
          {
            $xfer += $iter206->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listTagsByNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $notebookGuid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'notebookGuid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['notebookGuid'])) {
        $this->notebookGuid = $vals['notebookGuid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listTagsByNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->notebookGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listTagsByNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notebookGuid !== null) {
      $xfer += $output->writeFieldBegin('notebookGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->notebookGuid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listTagsByNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\Tag',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listTagsByNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size207 = 0;
            $_etype210 = 0;
            $xfer += $input->readListBegin($_etype210, $_size207);
            for ($_i211 = 0; $_i211 < $_size207; ++$_i211)
            {
              $elem212 = null;
              $elem212 = new \EDAM\Types\Tag();
              $xfer += $elem212->read($input);
              $this->success []= $elem212;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listTagsByNotebook_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter213)
          {
            $xfer += $iter213->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getTag_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getTag_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getTag_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getTag_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Tag',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getTag_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Tag();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getTag_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createTag_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $tag = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'tag',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Tag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['tag'])) {
        $this->tag = $vals['tag'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createTag_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->tag = new \EDAM\Types\Tag();
            $xfer += $this->tag->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createTag_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tag !== null) {
      if (!is_object($this->tag)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tag', \TType::STRUCT, 2);
      $xfer += $this->tag->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createTag_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Tag',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createTag_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Tag();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createTag_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateTag_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $tag = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'tag',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Tag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['tag'])) {
        $this->tag = $vals['tag'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateTag_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->tag = new \EDAM\Types\Tag();
            $xfer += $this->tag->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateTag_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tag !== null) {
      if (!is_object($this->tag)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tag', \TType::STRUCT, 2);
      $xfer += $this->tag->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateTag_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateTag_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateTag_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_untagAll_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_untagAll_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_untagAll_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_untagAll_result {
  static $_TSPEC;

  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_untagAll_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_untagAll_result');
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeTag_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeTag_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeTag_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeTag_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeTag_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeTag_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listSearches_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listSearches_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listSearches_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listSearches_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\SavedSearch',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listSearches_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size214 = 0;
            $_etype217 = 0;
            $xfer += $input->readListBegin($_etype217, $_size214);
            for ($_i218 = 0; $_i218 < $_size214; ++$_i218)
            {
              $elem219 = null;
              $elem219 = new \EDAM\Types\SavedSearch();
              $xfer += $elem219->read($input);
              $this->success []= $elem219;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listSearches_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter220)
          {
            $xfer += $iter220->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSearch_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSearch_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSearch_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSearch_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SavedSearch',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSearch_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\SavedSearch();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSearch_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createSearch_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $search = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'search',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SavedSearch',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['search'])) {
        $this->search = $vals['search'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createSearch_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->search = new \EDAM\Types\SavedSearch();
            $xfer += $this->search->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createSearch_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->search !== null) {
      if (!is_object($this->search)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('search', \TType::STRUCT, 2);
      $xfer += $this->search->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createSearch_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SavedSearch',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createSearch_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\SavedSearch();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createSearch_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateSearch_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $search = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'search',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SavedSearch',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['search'])) {
        $this->search = $vals['search'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateSearch_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->search = new \EDAM\Types\SavedSearch();
            $xfer += $this->search->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateSearch_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->search !== null) {
      if (!is_object($this->search)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('search', \TType::STRUCT, 2);
      $xfer += $this->search->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateSearch_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateSearch_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateSearch_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeSearch_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeSearch_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeSearch_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeSearch_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeSearch_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeSearch_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNotes_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $filter = null;
  public $offset = null;
  public $maxNotes = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteFilter',
          ),
        3 => array(
          'var' => 'offset',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'maxNotes',
          'type' => \TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
      if (isset($vals['maxNotes'])) {
        $this->maxNotes = $vals['maxNotes'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNotes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->filter = new \EDAM\NoteStore\NoteFilter();
            $xfer += $this->filter->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->maxNotes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNotes_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      if (!is_object($this->filter)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filter', \TType::STRUCT, 2);
      $xfer += $this->filter->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', \TType::I32, 3);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxNotes !== null) {
      $xfer += $output->writeFieldBegin('maxNotes', \TType::I32, 4);
      $xfer += $output->writeI32($this->maxNotes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNotes_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteList',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNotes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\NoteList();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNotes_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNoteOffset_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $filter = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteFilter',
          ),
        3 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNoteOffset_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->filter = new \EDAM\NoteStore\NoteFilter();
            $xfer += $this->filter->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNoteOffset_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      if (!is_object($this->filter)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filter', \TType::STRUCT, 2);
      $xfer += $this->filter->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 3);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNoteOffset_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNoteOffset_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNoteOffset_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNotesMetadata_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $filter = null;
  public $offset = null;
  public $maxNotes = null;
  public $resultSpec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteFilter',
          ),
        3 => array(
          'var' => 'offset',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'maxNotes',
          'type' => \TType::I32,
          ),
        5 => array(
          'var' => 'resultSpec',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NotesMetadataResultSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
      if (isset($vals['maxNotes'])) {
        $this->maxNotes = $vals['maxNotes'];
      }
      if (isset($vals['resultSpec'])) {
        $this->resultSpec = $vals['resultSpec'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNotesMetadata_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->filter = new \EDAM\NoteStore\NoteFilter();
            $xfer += $this->filter->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->maxNotes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::STRUCT) {
            $this->resultSpec = new \EDAM\NoteStore\NotesMetadataResultSpec();
            $xfer += $this->resultSpec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNotesMetadata_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      if (!is_object($this->filter)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filter', \TType::STRUCT, 2);
      $xfer += $this->filter->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', \TType::I32, 3);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxNotes !== null) {
      $xfer += $output->writeFieldBegin('maxNotes', \TType::I32, 4);
      $xfer += $output->writeI32($this->maxNotes);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resultSpec !== null) {
      if (!is_object($this->resultSpec)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resultSpec', \TType::STRUCT, 5);
      $xfer += $this->resultSpec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNotesMetadata_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NotesMetadataList',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNotesMetadata_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\NotesMetadataList();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNotesMetadata_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNoteCounts_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $filter = null;
  public $withTrash = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteFilter',
          ),
        3 => array(
          'var' => 'withTrash',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['withTrash'])) {
        $this->withTrash = $vals['withTrash'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNoteCounts_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->filter = new \EDAM\NoteStore\NoteFilter();
            $xfer += $this->filter->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withTrash);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNoteCounts_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      if (!is_object($this->filter)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filter', \TType::STRUCT, 2);
      $xfer += $this->filter->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withTrash !== null) {
      $xfer += $output->writeFieldBegin('withTrash', \TType::BOOL, 3);
      $xfer += $output->writeBool($this->withTrash);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findNoteCounts_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteCollectionCounts',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findNoteCounts_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\NoteCollectionCounts();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findNoteCounts_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $withContent = null;
  public $withResourcesData = null;
  public $withResourcesRecognition = null;
  public $withResourcesAlternateData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'withContent',
          'type' => \TType::BOOL,
          ),
        4 => array(
          'var' => 'withResourcesData',
          'type' => \TType::BOOL,
          ),
        5 => array(
          'var' => 'withResourcesRecognition',
          'type' => \TType::BOOL,
          ),
        6 => array(
          'var' => 'withResourcesAlternateData',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['withContent'])) {
        $this->withContent = $vals['withContent'];
      }
      if (isset($vals['withResourcesData'])) {
        $this->withResourcesData = $vals['withResourcesData'];
      }
      if (isset($vals['withResourcesRecognition'])) {
        $this->withResourcesRecognition = $vals['withResourcesRecognition'];
      }
      if (isset($vals['withResourcesAlternateData'])) {
        $this->withResourcesAlternateData = $vals['withResourcesAlternateData'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withContent);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesRecognition);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesAlternateData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withContent !== null) {
      $xfer += $output->writeFieldBegin('withContent', \TType::BOOL, 3);
      $xfer += $output->writeBool($this->withContent);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesData !== null) {
      $xfer += $output->writeFieldBegin('withResourcesData', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->withResourcesData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesRecognition !== null) {
      $xfer += $output->writeFieldBegin('withResourcesRecognition', \TType::BOOL, 5);
      $xfer += $output->writeBool($this->withResourcesRecognition);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesAlternateData !== null) {
      $xfer += $output->writeFieldBegin('withResourcesAlternateData', \TType::BOOL, 6);
      $xfer += $output->writeBool($this->withResourcesAlternateData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Note();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNote_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteApplicationData_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteApplicationData_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteApplicationData_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteApplicationData_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LazyMap',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteApplicationData_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\LazyMap();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteApplicationData_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setNoteApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        4 => array(
          'var' => 'value',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setNoteApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setNoteApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', \TType::STRING, 4);
      $xfer += $output->writeString($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setNoteApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setNoteApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setNoteApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_unsetNoteApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_unsetNoteApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_unsetNoteApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_unsetNoteApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_unsetNoteApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_unsetNoteApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteContent_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteContent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteContent_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteContent_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteContent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteContent_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteSearchText_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $noteOnly = null;
  public $tokenizeForIndexing = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'noteOnly',
          'type' => \TType::BOOL,
          ),
        4 => array(
          'var' => 'tokenizeForIndexing',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['noteOnly'])) {
        $this->noteOnly = $vals['noteOnly'];
      }
      if (isset($vals['tokenizeForIndexing'])) {
        $this->tokenizeForIndexing = $vals['tokenizeForIndexing'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteSearchText_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->noteOnly);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->tokenizeForIndexing);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteSearchText_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteOnly !== null) {
      $xfer += $output->writeFieldBegin('noteOnly', \TType::BOOL, 3);
      $xfer += $output->writeBool($this->noteOnly);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tokenizeForIndexing !== null) {
      $xfer += $output->writeFieldBegin('tokenizeForIndexing', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->tokenizeForIndexing);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteSearchText_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteSearchText_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteSearchText_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceSearchText_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceSearchText_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceSearchText_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceSearchText_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceSearchText_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceSearchText_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteTagNames_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteTagNames_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteTagNames_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteTagNames_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRING,
          'elem' => array(
            'type' => \TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteTagNames_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size221 = 0;
            $_etype224 = 0;
            $xfer += $input->readListBegin($_etype224, $_size221);
            for ($_i225 = 0; $_i225 < $_size221; ++$_i225)
            {
              $elem226 = null;
              $xfer += $input->readString($elem226);
              $this->success []= $elem226;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteTagNames_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter227)
          {
            $xfer += $output->writeString($iter227);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $note = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'note',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['note'])) {
        $this->note = $vals['note'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->note = new \EDAM\Types\Note();
            $xfer += $this->note->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->note !== null) {
      if (!is_object($this->note)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('note', \TType::STRUCT, 2);
      $xfer += $this->note->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Note();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createNote_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $note = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'note',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['note'])) {
        $this->note = $vals['note'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->note = new \EDAM\Types\Note();
            $xfer += $this->note->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->note !== null) {
      if (!is_object($this->note)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('note', \TType::STRUCT, 2);
      $xfer += $this->note->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Note();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateNote_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_deleteNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_deleteNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_deleteNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_deleteNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_deleteNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_deleteNote_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNote_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNotes_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $noteGuids = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteGuids',
          'type' => \TType::LST,
          'etype' => \TType::STRING,
          'elem' => array(
            'type' => \TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['noteGuids'])) {
        $this->noteGuids = $vals['noteGuids'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNotes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::LST) {
            $this->noteGuids = array();
            $_size228 = 0;
            $_etype231 = 0;
            $xfer += $input->readListBegin($_etype231, $_size228);
            for ($_i232 = 0; $_i232 < $_size228; ++$_i232)
            {
              $elem233 = null;
              $xfer += $input->readString($elem233);
              $this->noteGuids []= $elem233;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNotes_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteGuids !== null) {
      if (!is_array($this->noteGuids)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('noteGuids', \TType::LST, 2);
      {
        $output->writeListBegin(\TType::STRING, count($this->noteGuids));
        {
          foreach ($this->noteGuids as $iter234)
          {
            $xfer += $output->writeString($iter234);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeNotes_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeNotes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeNotes_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeInactiveNotes_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeInactiveNotes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeInactiveNotes_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeInactiveNotes_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeInactiveNotes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeInactiveNotes_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_copyNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $noteGuid = null;
  public $toNotebookGuid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteGuid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'toNotebookGuid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['noteGuid'])) {
        $this->noteGuid = $vals['noteGuid'];
      }
      if (isset($vals['toNotebookGuid'])) {
        $this->toNotebookGuid = $vals['toNotebookGuid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_copyNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->noteGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->toNotebookGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_copyNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteGuid !== null) {
      $xfer += $output->writeFieldBegin('noteGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->noteGuid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->toNotebookGuid !== null) {
      $xfer += $output->writeFieldBegin('toNotebookGuid', \TType::STRING, 3);
      $xfer += $output->writeString($this->toNotebookGuid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_copyNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_copyNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Note();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_copyNote_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listNoteVersions_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $noteGuid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteGuid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['noteGuid'])) {
        $this->noteGuid = $vals['noteGuid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listNoteVersions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->noteGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listNoteVersions_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteGuid !== null) {
      $xfer += $output->writeFieldBegin('noteGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->noteGuid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listNoteVersions_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\NoteStore\NoteVersionId',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listNoteVersions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size235 = 0;
            $_etype238 = 0;
            $xfer += $input->readListBegin($_etype238, $_size235);
            for ($_i239 = 0; $_i239 < $_size235; ++$_i239)
            {
              $elem240 = null;
              $elem240 = new \EDAM\NoteStore\NoteVersionId();
              $xfer += $elem240->read($input);
              $this->success []= $elem240;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listNoteVersions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter241)
          {
            $xfer += $iter241->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteVersion_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $noteGuid = null;
  public $updateSequenceNum = null;
  public $withResourcesData = null;
  public $withResourcesRecognition = null;
  public $withResourcesAlternateData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteGuid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'updateSequenceNum',
          'type' => \TType::I32,
          ),
        4 => array(
          'var' => 'withResourcesData',
          'type' => \TType::BOOL,
          ),
        5 => array(
          'var' => 'withResourcesRecognition',
          'type' => \TType::BOOL,
          ),
        6 => array(
          'var' => 'withResourcesAlternateData',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['noteGuid'])) {
        $this->noteGuid = $vals['noteGuid'];
      }
      if (isset($vals['updateSequenceNum'])) {
        $this->updateSequenceNum = $vals['updateSequenceNum'];
      }
      if (isset($vals['withResourcesData'])) {
        $this->withResourcesData = $vals['withResourcesData'];
      }
      if (isset($vals['withResourcesRecognition'])) {
        $this->withResourcesRecognition = $vals['withResourcesRecognition'];
      }
      if (isset($vals['withResourcesAlternateData'])) {
        $this->withResourcesAlternateData = $vals['withResourcesAlternateData'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteVersion_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->noteGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->updateSequenceNum);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesRecognition);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withResourcesAlternateData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteVersion_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteGuid !== null) {
      $xfer += $output->writeFieldBegin('noteGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->noteGuid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updateSequenceNum !== null) {
      $xfer += $output->writeFieldBegin('updateSequenceNum', \TType::I32, 3);
      $xfer += $output->writeI32($this->updateSequenceNum);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesData !== null) {
      $xfer += $output->writeFieldBegin('withResourcesData', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->withResourcesData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesRecognition !== null) {
      $xfer += $output->writeFieldBegin('withResourcesRecognition', \TType::BOOL, 5);
      $xfer += $output->writeBool($this->withResourcesRecognition);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withResourcesAlternateData !== null) {
      $xfer += $output->writeFieldBegin('withResourcesAlternateData', \TType::BOOL, 6);
      $xfer += $output->writeBool($this->withResourcesAlternateData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getNoteVersion_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Note',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getNoteVersion_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Note();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getNoteVersion_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResource_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $withData = null;
  public $withRecognition = null;
  public $withAttributes = null;
  public $withAlternateData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'withData',
          'type' => \TType::BOOL,
          ),
        4 => array(
          'var' => 'withRecognition',
          'type' => \TType::BOOL,
          ),
        5 => array(
          'var' => 'withAttributes',
          'type' => \TType::BOOL,
          ),
        6 => array(
          'var' => 'withAlternateData',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['withData'])) {
        $this->withData = $vals['withData'];
      }
      if (isset($vals['withRecognition'])) {
        $this->withRecognition = $vals['withRecognition'];
      }
      if (isset($vals['withAttributes'])) {
        $this->withAttributes = $vals['withAttributes'];
      }
      if (isset($vals['withAlternateData'])) {
        $this->withAlternateData = $vals['withAlternateData'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withRecognition);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withAttributes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withAlternateData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResource_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withData !== null) {
      $xfer += $output->writeFieldBegin('withData', \TType::BOOL, 3);
      $xfer += $output->writeBool($this->withData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withRecognition !== null) {
      $xfer += $output->writeFieldBegin('withRecognition', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->withRecognition);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withAttributes !== null) {
      $xfer += $output->writeFieldBegin('withAttributes', \TType::BOOL, 5);
      $xfer += $output->writeBool($this->withAttributes);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withAlternateData !== null) {
      $xfer += $output->writeFieldBegin('withAlternateData', \TType::BOOL, 6);
      $xfer += $output->writeBool($this->withAlternateData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResource_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Resource',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Resource();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResource_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceApplicationData_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceApplicationData_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceApplicationData_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceApplicationData_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LazyMap',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceApplicationData_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\LazyMap();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceApplicationData_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setResourceApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        4 => array(
          'var' => 'value',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setResourceApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setResourceApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', \TType::STRING, 4);
      $xfer += $output->writeString($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setResourceApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setResourceApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setResourceApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_unsetResourceApplicationDataEntry_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_unsetResourceApplicationDataEntry_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_unsetResourceApplicationDataEntry_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', \TType::STRING, 3);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_unsetResourceApplicationDataEntry_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_unsetResourceApplicationDataEntry_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_unsetResourceApplicationDataEntry_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateResource_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $resource = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'resource',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Resource',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['resource'])) {
        $this->resource = $vals['resource'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->resource = new \EDAM\Types\Resource();
            $xfer += $this->resource->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateResource_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resource !== null) {
      if (!is_object($this->resource)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resource', \TType::STRUCT, 2);
      $xfer += $this->resource->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateResource_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateResource_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceData_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceData_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceData_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceData_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceData_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceData_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceByHash_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $noteGuid = null;
  public $contentHash = null;
  public $withData = null;
  public $withRecognition = null;
  public $withAlternateData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteGuid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'contentHash',
          'type' => \TType::STRING,
          ),
        4 => array(
          'var' => 'withData',
          'type' => \TType::BOOL,
          ),
        5 => array(
          'var' => 'withRecognition',
          'type' => \TType::BOOL,
          ),
        6 => array(
          'var' => 'withAlternateData',
          'type' => \TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['noteGuid'])) {
        $this->noteGuid = $vals['noteGuid'];
      }
      if (isset($vals['contentHash'])) {
        $this->contentHash = $vals['contentHash'];
      }
      if (isset($vals['withData'])) {
        $this->withData = $vals['withData'];
      }
      if (isset($vals['withRecognition'])) {
        $this->withRecognition = $vals['withRecognition'];
      }
      if (isset($vals['withAlternateData'])) {
        $this->withAlternateData = $vals['withAlternateData'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceByHash_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->noteGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->contentHash);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withRecognition);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == \TType::BOOL) {
            $xfer += $input->readBool($this->withAlternateData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceByHash_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteGuid !== null) {
      $xfer += $output->writeFieldBegin('noteGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->noteGuid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->contentHash !== null) {
      $xfer += $output->writeFieldBegin('contentHash', \TType::STRING, 3);
      $xfer += $output->writeString($this->contentHash);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withData !== null) {
      $xfer += $output->writeFieldBegin('withData', \TType::BOOL, 4);
      $xfer += $output->writeBool($this->withData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withRecognition !== null) {
      $xfer += $output->writeFieldBegin('withRecognition', \TType::BOOL, 5);
      $xfer += $output->writeBool($this->withRecognition);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->withAlternateData !== null) {
      $xfer += $output->writeFieldBegin('withAlternateData', \TType::BOOL, 6);
      $xfer += $output->writeBool($this->withAlternateData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceByHash_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Resource',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceByHash_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Resource();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceByHash_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceRecognition_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceRecognition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceRecognition_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceRecognition_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceRecognition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceRecognition_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceAlternateData_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceAlternateData_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceAlternateData_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceAlternateData_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceAlternateData_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceAlternateData_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceAttributes_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceAttributes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceAttributes_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getResourceAttributes_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\ResourceAttributes',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getResourceAttributes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\ResourceAttributes();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getResourceAttributes_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getPublicNotebook_args {
  static $_TSPEC;

  public $userId = null;
  public $publicUri = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userId',
          'type' => \TType::I32,
          ),
        2 => array(
          'var' => 'publicUri',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userId'])) {
        $this->userId = $vals['userId'];
      }
      if (isset($vals['publicUri'])) {
        $this->publicUri = $vals['publicUri'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getPublicNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->userId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->publicUri);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getPublicNotebook_args');
    if ($this->userId !== null) {
      $xfer += $output->writeFieldBegin('userId', \TType::I32, 1);
      $xfer += $output->writeI32($this->userId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->publicUri !== null) {
      $xfer += $output->writeFieldBegin('publicUri', \TType::STRING, 2);
      $xfer += $output->writeString($this->publicUri);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getPublicNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\Notebook',
          ),
        1 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getPublicNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\Notebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getPublicNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 1);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createSharedNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $sharedNotebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'sharedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SharedNotebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['sharedNotebook'])) {
        $this->sharedNotebook = $vals['sharedNotebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createSharedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->sharedNotebook = new \EDAM\Types\SharedNotebook();
            $xfer += $this->sharedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createSharedNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sharedNotebook !== null) {
      if (!is_object($this->sharedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sharedNotebook', \TType::STRUCT, 2);
      $xfer += $this->sharedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createSharedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SharedNotebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createSharedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\SharedNotebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createSharedNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateSharedNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $sharedNotebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'sharedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SharedNotebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['sharedNotebook'])) {
        $this->sharedNotebook = $vals['sharedNotebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateSharedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->sharedNotebook = new \EDAM\Types\SharedNotebook();
            $xfer += $this->sharedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateSharedNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sharedNotebook !== null) {
      if (!is_object($this->sharedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sharedNotebook', \TType::STRUCT, 2);
      $xfer += $this->sharedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateSharedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateSharedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateSharedNotebook_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setSharedNotebookRecipientSettings_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $sharedNotebookId = null;
  public $recipientSettings = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'sharedNotebookId',
          'type' => \TType::I64,
          ),
        3 => array(
          'var' => 'recipientSettings',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SharedNotebookRecipientSettings',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['sharedNotebookId'])) {
        $this->sharedNotebookId = $vals['sharedNotebookId'];
      }
      if (isset($vals['recipientSettings'])) {
        $this->recipientSettings = $vals['recipientSettings'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setSharedNotebookRecipientSettings_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::I64) {
            $xfer += $input->readI64($this->sharedNotebookId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->recipientSettings = new \EDAM\Types\SharedNotebookRecipientSettings();
            $xfer += $this->recipientSettings->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setSharedNotebookRecipientSettings_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sharedNotebookId !== null) {
      $xfer += $output->writeFieldBegin('sharedNotebookId', \TType::I64, 2);
      $xfer += $output->writeI64($this->sharedNotebookId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->recipientSettings !== null) {
      if (!is_object($this->recipientSettings)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('recipientSettings', \TType::STRUCT, 3);
      $xfer += $this->recipientSettings->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_setSharedNotebookRecipientSettings_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_setSharedNotebookRecipientSettings_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_setSharedNotebookRecipientSettings_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_sendMessageToSharedNotebookMembers_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $notebookGuid = null;
  public $messageText = null;
  public $recipients = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'notebookGuid',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'messageText',
          'type' => \TType::STRING,
          ),
        4 => array(
          'var' => 'recipients',
          'type' => \TType::LST,
          'etype' => \TType::STRING,
          'elem' => array(
            'type' => \TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['notebookGuid'])) {
        $this->notebookGuid = $vals['notebookGuid'];
      }
      if (isset($vals['messageText'])) {
        $this->messageText = $vals['messageText'];
      }
      if (isset($vals['recipients'])) {
        $this->recipients = $vals['recipients'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_sendMessageToSharedNotebookMembers_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->notebookGuid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->messageText);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == \TType::LST) {
            $this->recipients = array();
            $_size242 = 0;
            $_etype245 = 0;
            $xfer += $input->readListBegin($_etype245, $_size242);
            for ($_i246 = 0; $_i246 < $_size242; ++$_i246)
            {
              $elem247 = null;
              $xfer += $input->readString($elem247);
              $this->recipients []= $elem247;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_sendMessageToSharedNotebookMembers_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notebookGuid !== null) {
      $xfer += $output->writeFieldBegin('notebookGuid', \TType::STRING, 2);
      $xfer += $output->writeString($this->notebookGuid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->messageText !== null) {
      $xfer += $output->writeFieldBegin('messageText', \TType::STRING, 3);
      $xfer += $output->writeString($this->messageText);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->recipients !== null) {
      if (!is_array($this->recipients)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('recipients', \TType::LST, 4);
      {
        $output->writeListBegin(\TType::STRING, count($this->recipients));
        {
          foreach ($this->recipients as $iter248)
          {
            $xfer += $output->writeString($iter248);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_sendMessageToSharedNotebookMembers_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_sendMessageToSharedNotebookMembers_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_sendMessageToSharedNotebookMembers_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listSharedNotebooks_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listSharedNotebooks_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listSharedNotebooks_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listSharedNotebooks_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\SharedNotebook',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listSharedNotebooks_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size249 = 0;
            $_etype252 = 0;
            $xfer += $input->readListBegin($_etype252, $_size249);
            for ($_i253 = 0; $_i253 < $_size249; ++$_i253)
            {
              $elem254 = null;
              $elem254 = new \EDAM\Types\SharedNotebook();
              $xfer += $elem254->read($input);
              $this->success []= $elem254;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listSharedNotebooks_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter255)
          {
            $xfer += $iter255->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeSharedNotebooks_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $sharedNotebookIds = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'sharedNotebookIds',
          'type' => \TType::LST,
          'etype' => \TType::I64,
          'elem' => array(
            'type' => \TType::I64,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['sharedNotebookIds'])) {
        $this->sharedNotebookIds = $vals['sharedNotebookIds'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeSharedNotebooks_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::LST) {
            $this->sharedNotebookIds = array();
            $_size256 = 0;
            $_etype259 = 0;
            $xfer += $input->readListBegin($_etype259, $_size256);
            for ($_i260 = 0; $_i260 < $_size256; ++$_i260)
            {
              $elem261 = null;
              $xfer += $input->readI64($elem261);
              $this->sharedNotebookIds []= $elem261;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeSharedNotebooks_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sharedNotebookIds !== null) {
      if (!is_array($this->sharedNotebookIds)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sharedNotebookIds', \TType::LST, 2);
      {
        $output->writeListBegin(\TType::I64, count($this->sharedNotebookIds));
        {
          foreach ($this->sharedNotebookIds as $iter262)
          {
            $xfer += $output->writeI64($iter262);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeSharedNotebooks_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeSharedNotebooks_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeSharedNotebooks_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createLinkedNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $linkedNotebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'linkedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LinkedNotebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['linkedNotebook'])) {
        $this->linkedNotebook = $vals['linkedNotebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createLinkedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->linkedNotebook = new \EDAM\Types\LinkedNotebook();
            $xfer += $this->linkedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createLinkedNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->linkedNotebook !== null) {
      if (!is_object($this->linkedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('linkedNotebook', \TType::STRUCT, 2);
      $xfer += $this->linkedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_createLinkedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LinkedNotebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_createLinkedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\LinkedNotebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_createLinkedNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateLinkedNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $linkedNotebook = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'linkedNotebook',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\LinkedNotebook',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['linkedNotebook'])) {
        $this->linkedNotebook = $vals['linkedNotebook'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateLinkedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->linkedNotebook = new \EDAM\Types\LinkedNotebook();
            $xfer += $this->linkedNotebook->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateLinkedNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->linkedNotebook !== null) {
      if (!is_object($this->linkedNotebook)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('linkedNotebook', \TType::STRUCT, 2);
      $xfer += $this->linkedNotebook->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_updateLinkedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_updateLinkedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_updateLinkedNotebook_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listLinkedNotebooks_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listLinkedNotebooks_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listLinkedNotebooks_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_listLinkedNotebooks_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::LST,
          'etype' => \TType::STRUCT,
          'elem' => array(
            'type' => \TType::STRUCT,
            'class' => '\EDAM\Types\LinkedNotebook',
            ),
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_listLinkedNotebooks_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::LST) {
            $this->success = array();
            $_size263 = 0;
            $_etype266 = 0;
            $xfer += $input->readListBegin($_etype266, $_size263);
            for ($_i267 = 0; $_i267 < $_size263; ++$_i267)
            {
              $elem268 = null;
              $elem268 = new \EDAM\Types\LinkedNotebook();
              $xfer += $elem268->read($input);
              $this->success []= $elem268;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_listLinkedNotebooks_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::LST, 0);
      {
        $output->writeListBegin(\TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter269)
          {
            $xfer += $iter269->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeLinkedNotebook_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeLinkedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeLinkedNotebook_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_expungeLinkedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::I32,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_expungeLinkedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_expungeLinkedNotebook_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_authenticateToSharedNotebook_args {
  static $_TSPEC;

  public $shareKey = null;
  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'shareKey',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['shareKey'])) {
        $this->shareKey = $vals['shareKey'];
      }
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_authenticateToSharedNotebook_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->shareKey);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_authenticateToSharedNotebook_args');
    if ($this->shareKey !== null) {
      $xfer += $output->writeFieldBegin('shareKey', \TType::STRING, 1);
      $xfer += $output->writeString($this->shareKey);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 2);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_authenticateToSharedNotebook_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\UserStore\AuthenticationResult',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_authenticateToSharedNotebook_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\UserStore\AuthenticationResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_authenticateToSharedNotebook_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSharedNotebookByAuth_args {
  static $_TSPEC;

  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSharedNotebookByAuth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSharedNotebookByAuth_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_getSharedNotebookByAuth_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Types\SharedNotebook',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_getSharedNotebookByAuth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\Types\SharedNotebook();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_getSharedNotebookByAuth_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_emailNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $parameters = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'parameters',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\NoteEmailParameters',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['parameters'])) {
        $this->parameters = $vals['parameters'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_emailNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->parameters = new \EDAM\NoteStore\NoteEmailParameters();
            $xfer += $this->parameters->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_emailNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->parameters !== null) {
      if (!is_object($this->parameters)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('parameters', \TType::STRUCT, 2);
      $xfer += $this->parameters->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_emailNote_result {
  static $_TSPEC;

  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_emailNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_emailNote_result');
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_shareNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_shareNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_shareNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_shareNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRING,
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_shareNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_shareNote_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', \TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_stopSharingNote_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $guid = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_stopSharingNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_stopSharingNote_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 2);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_stopSharingNote_result {
  static $_TSPEC;

  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_stopSharingNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_stopSharingNote_result');
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_authenticateToSharedNote_args {
  static $_TSPEC;

  public $guid = null;
  public $noteKey = null;
  public $authenticationToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'guid',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'noteKey',
          'type' => \TType::STRING,
          ),
        3 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['guid'])) {
        $this->guid = $vals['guid'];
      }
      if (isset($vals['noteKey'])) {
        $this->noteKey = $vals['noteKey'];
      }
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_authenticateToSharedNote_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->guid);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->noteKey);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_authenticateToSharedNote_args');
    if ($this->guid !== null) {
      $xfer += $output->writeFieldBegin('guid', \TType::STRING, 1);
      $xfer += $output->writeString($this->guid);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noteKey !== null) {
      $xfer += $output->writeFieldBegin('noteKey', \TType::STRING, 2);
      $xfer += $output->writeString($this->noteKey);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 3);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_authenticateToSharedNote_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $notFoundException = null;
  public $systemException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\UserStore\AuthenticationResult',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        3 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_authenticateToSharedNote_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\UserStore\AuthenticationResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_authenticateToSharedNote_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 2);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 3);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findRelated_args {
  static $_TSPEC;

  public $authenticationToken = null;
  public $query = null;
  public $resultSpec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authenticationToken',
          'type' => \TType::STRING,
          ),
        2 => array(
          'var' => 'query',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\RelatedQuery',
          ),
        3 => array(
          'var' => 'resultSpec',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\RelatedResultSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authenticationToken'])) {
        $this->authenticationToken = $vals['authenticationToken'];
      }
      if (isset($vals['query'])) {
        $this->query = $vals['query'];
      }
      if (isset($vals['resultSpec'])) {
        $this->resultSpec = $vals['resultSpec'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findRelated_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == \TType::STRING) {
            $xfer += $input->readString($this->authenticationToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->query = new \EDAM\NoteStore\RelatedQuery();
            $xfer += $this->query->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->resultSpec = new \EDAM\NoteStore\RelatedResultSpec();
            $xfer += $this->resultSpec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findRelated_args');
    if ($this->authenticationToken !== null) {
      $xfer += $output->writeFieldBegin('authenticationToken', \TType::STRING, 1);
      $xfer += $output->writeString($this->authenticationToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->query !== null) {
      if (!is_object($this->query)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('query', \TType::STRUCT, 2);
      $xfer += $this->query->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resultSpec !== null) {
      if (!is_object($this->resultSpec)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resultSpec', \TType::STRUCT, 3);
      $xfer += $this->resultSpec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class NoteStore_findRelated_result {
  static $_TSPEC;

  public $success = null;
  public $userException = null;
  public $systemException = null;
  public $notFoundException = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\NoteStore\RelatedResult',
          ),
        1 => array(
          'var' => 'userException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMUserException',
          ),
        2 => array(
          'var' => 'systemException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMSystemException',
          ),
        3 => array(
          'var' => 'notFoundException',
          'type' => \TType::STRUCT,
          'class' => '\EDAM\Error\EDAMNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['userException'])) {
        $this->userException = $vals['userException'];
      }
      if (isset($vals['systemException'])) {
        $this->systemException = $vals['systemException'];
      }
      if (isset($vals['notFoundException'])) {
        $this->notFoundException = $vals['notFoundException'];
      }
    }
  }

  public function getName() {
    return 'NoteStore_findRelated_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == \TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == \TType::STRUCT) {
            $this->success = new \EDAM\NoteStore\RelatedResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == \TType::STRUCT) {
            $this->userException = new \EDAM\Error\EDAMUserException();
            $xfer += $this->userException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == \TType::STRUCT) {
            $this->systemException = new \EDAM\Error\EDAMSystemException();
            $xfer += $this->systemException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == \TType::STRUCT) {
            $this->notFoundException = new \EDAM\Error\EDAMNotFoundException();
            $xfer += $this->notFoundException->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('NoteStore_findRelated_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new \TProtocolException('Bad type in structure.', \TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', \TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userException !== null) {
      $xfer += $output->writeFieldBegin('userException', \TType::STRUCT, 1);
      $xfer += $this->userException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->systemException !== null) {
      $xfer += $output->writeFieldBegin('systemException', \TType::STRUCT, 2);
      $xfer += $this->systemException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notFoundException !== null) {
      $xfer += $output->writeFieldBegin('notFoundException', \TType::STRUCT, 3);
      $xfer += $this->notFoundException->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

?>
